var isonArray_i, isonArray_length, ia = ia || {}, vx_utils = vx_utils || {};

function roundNumber(num, dec){
	var result=Math.round(num * Math.pow(10, dec)) / Math.pow(10, dec);
	return result;
}

function CommaFormatted(amount, depth, delimiter){
	if(!depth) var depth=2;
    if(typeof delimiter=="undefined") var delimiter=",";
	amount=roundNumber(amount, depth)
	amount=amount.toFixed(depth)

	var a=amount.split('.', depth), d=a[1], i=parseInt(a[0]), minus='', n, nn;
	if(isNaN(i)) return '';
	if(i < 0) minus='-';
	i=Math.abs(i);
	n=new String(i);
	a=[];
	while (n.length > 3){
		nn=n.substr(n.length - 3);
		a.unshift(nn);
		n=n.substr(0, n.length - 3);
	}
	if(n.length > 0) a.unshift(n);
	n=a.join(delimiter);
	if(d.length < 1)
		amount=n;
	else
		amount=n + '.' + d;
	amount=minus + amount;
	return amount;
}

function numbersonly(e, decimal){
	var key;
	var keychar;
	if (window.event){
		key=window.event.keyCode;
	} else if (e){
		key=e.which;
	} else {
		return true;
	}
	keychar=String.fromCharCode(key);
	if ((key==null) || (key==0) || (key==8) || (key==9) || (key==13) || (key==27)){
		return true;
	} else if ((("0123456789").indexOf(keychar) > -1)){
		return true;
	} else if (decimal && ((keychar==".") || (keychar=="-"))){
		return true;
	} else
	return false;
}

function uppercase(){
	key=window.event.keyCode;
	if (((key > 0x60) && (key < 0x7B)) || ((key > 0xDF) && (key < 0xFD))) window.event.keyCode=key - 0x20;
	if (key==0xF1) window.event.keyCode=0xD1;
}

function strtrim(str){
	var str=str.replace(/^\s\s*/, ''),
		ws=/\s/,
		i=str.length;
	while (ws.test(str.charAt(--i)));
	return str.slice(0, i + 1);
}

function hasClass(ele, cls){
	return ele.className.match(new RegExp('(\\s|^)' + cls + '(\\s|$)'));
}

function addClass(ele, cls){
	if (!this.hasClass(ele, cls)) ele.className += " " + cls;
}

function removeClass(ele, cls){
	if (hasClass(ele, cls)){
		var reg=new RegExp('(\\s|^)' + cls + '(\\s|$)');
		ele.className=ele.className.replace(reg, ' ');
	}
}

function FechaporDefault(ID){
	if (ID=='') return;
	if ($('#' + ID).val()==''){
		var now=new Date();
		//document.getElementById(ID).value=now.toString('dd-MM-yyyy');
		$('#' + ID).val($.datepicker.formatDate('dd-mm-yy', now));
	}
}

function VerificayCorrigeFecha(Fecha, campo, corrige, permiteVacio){
	var FechaaCorregir=Fecha;
	var CaracterDivisor='';
	var aFecha;
	var iDia;
	var iMes;
	var iAnio;
	var sDia;
	var sMes;
	var sAnio;
	var sFechaCorregida, sFechaCorregidaBW;
	var sFechaCaret='dd-mm-AAAA';
	var formatoFecha='mx';
	if (typeof _app!='undefined' && (_app=='edocta' || _app=='cuenta_t')){
		formatoFecha='mx';
		sFechaCaret='dd-mm-AAAA';
	} else {
		formatoFecha='mysql';
		sFechaCaret='AAAA-mm-dd';
	}
	if (!corrige) var corrige='SI';
	if (!permiteVacio) var permiteVacio='SI';
	if (FechaaCorregir.length==0){
		if (permiteVacio!='SI') vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		return false;
	}
	if (FechaaCorregir.length < 6 && FechaaCorregir.length > 0){
		vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		//document.getElementById(campo).focus();
		return false;
	}
	//Vamos a buscar el carácter con que están dividiendo la fecha.
	FechaaCorregir=FechaaCorregir.replace(/\//g, '-');
	FechaaCorregir=FechaaCorregir.replace(/\*/g, '-');
	FechaaCorregir=FechaaCorregir.replace(/\./g, '-');
	FechaaCorregir=FechaaCorregir.replace(/\_/g, '-');
	FechaaCorregir=FechaaCorregir.replace(/\+/g, '-');
	FechaaCorregir=FechaaCorregir.replace(/\\/g, '-');
	CaracterDivisor='-';
	aFecha=FechaaCorregir.split(CaracterDivisor);
	if (aFecha.length > 3){
		vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		//document.getElementById(campo).focus();
		return false;
	}
	switch (formatoFecha){
	case 'mx':
		iDia=aFecha[0];
		iMes=aFecha[1];
		iAnio=aFecha[2];
		sFechaCaret='dd-mm-AAAA';
		break;
	case 'mysql':
		iDia=aFecha[2];
		iMes=aFecha[1];
		iAnio=aFecha[0];
		sFechaCaret='AAAA-mm-dd';
		break;
	}
	if (isNaN(iDia) || isNaN(iMes) || isNaN(iAnio)){
		vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		//document.getElementById(campo).focus();
		return false;
	}
	if (parseInt(iMes, 10) > 12 || parseInt(iMes, 10) === 0){
		vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		//document.getElementById(campo).focus();
		return false;
	}
	if (parseInt(iDia, 10) > 31 || parseInt(iDia, 10) === 0){
		vx_alert(divIDInfo, '<strong>La Fecha tiene un formato inválido</strong>.<br/><br/>El formato correcto es: <strong>' + sFechaCaret + '</strong>.<li>Dos dígitos para el día, dos para el mes y cuatro para el año.', 'Validación de Fecha.', campo, '', '', '');
		//document.getElementById(campo).focus();
		return false;
	}
	iDia=parseInt(iDia, 10);
	iMes=parseInt(iMes, 10);
	iAnio=parseInt(iAnio, 10);
	if (iAnio < 30) iAnio += 2000;
	else if (iAnio < 99) iAnio += 1900;
	if (iDia < 10) sDia='0' + iDia.toString();
	else
	sDia=iDia.toString();
	if (iMes < 10) sMes='0' + iMes.toString();
	else
	sMes=iMes.toString();
	sAnio=iAnio.toString();
	sFechaCorregida=sDia + '-' + sMes + '-' + sAnio;
	sFechaCorregidaBW=sAnio + '-' + sMes + '-' + sDia;
	//Metemos una verificación de restricción.
	if (typeof _app!='undefined' && _app=='edocta'){
		var cFecha=new Date(sFechaCorregidaBW + ' GMT-0600');
		var cFLPC=new Date(flpC + ' GMT-0600');
		var cFLFC=new Date(flfC + ' GMT-0600');
		if (cFecha < cFLPC || cFecha > cFLFC){
			//document.getElementById(campo).focus();
			vx_alert(divIDInfo, '<strong>Fecha fuera del rango permitido. Por favor, usa el calendario para elegir la fecha.</strong>', 'Captura de Estado de Cuenta.', campo, '', '', '');
			return false;
		}
	}
	if (corrige=='SI') document.getElementById(campo).value=sFechaCorregida;
	return true;
}

function trapEnterAsTab() // called from an onKeyDown in the body	statement
{
	evt=event || window.event;
	if (evt.keyCode==13 && TextAreaFocused==false /* enter */ ) evt.keyCode=9 /* tab */
	;
}

function focusonTextArea(){
	TextAreaFocused=true;
}

function focusnotonTextArea(){
	TextAreaFocused=false;
}

function MostraruOcultarMenu(NombredelMenu, muo){
    muo=muo===undefined?'DEF':muo;

    if(muo=='DEF')
        $('#' + NombredelMenu).toggle('blind', 300);
    else
        $('#' + NombredelMenu).hide();
}

function nl2br(str){
	var breakTag='<br>';
	return (str + '').replace(/([^>\r\n]?)(\r\n|\n\r|\r|\n)/g, '$1' + breakTag + '$2');
}

function vx_isOnArray(arr, val){
	for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
	if (arr[isonArray_i]==val) return isonArray_i;
	return -1;
}

function getposonArray(arr, val, pos){
	if (!pos) var pos=0;
	for (isonArray_i=0, isonArray_length=arr.length; isonArray_i < isonArray_length; isonArray_i++)
	if (isArray(arr[isonArray_i])){
		if (arr[isonArray_i][pos]==val) return isonArray_i;
	} else
	if (arr[isonArray_i]==val) return isonArray_i;
	return false;
}

function InicializaWidthGrid(gh, forzar){
	if (!gh) var gh=gridhandler;
	if (!forzar) var forzar=false;
	if (!PrimeraVez || forzar){
		$(gh).setGridWidth($(gh).getGridParam('width') - 25, true);
		$(gh)[0].clearToolbar();
	}
	PrimeraVez=true;
}

function CambiaFormatoFecha(Fecha, formato){
	if (Fecha.length < 10) return '';
	if (!formato || formato.length==0) var formato='MySQL';
	var CaracterDivisor='-';
	var aFecha=Fecha.split(CaracterDivisor);
	var sDia=aFecha[0];
	var sMes=aFecha[1];
	var sAnio=aFecha[2];
	switch (formato){
	case 'MySQL':
		Fecha=sAnio + '-' + sMes + '-' + sDia;
		break;
	case 'JS':
		Fecha=sDia + '-' + sMes + '-' + sAnio;
		break;
	default:
		Fecha=sAnio + '-' + sMes + '-' + sDia;
		break;
	}
	return Fecha;
}

function RecuperaoEstableceEstilodeCampo(tabla, campo, id_nombre, id_valor, atributo, valor){
	if (!tabla || !campo || !id_nombre || !id_valor) return false;
	if (!valor) valor='read';
	if (!atributo) atributo='';
	if (window.XMLHttpRequest){
		xmlhttp=new XMLHttpRequest();
	} else {
		xmlhttp=new ActiveXObject("Microsoft.XMLHTTP");
	}
	xmlhttp.open("POST", "ajax/iaestilos.php", false);
	xmlhttp.setRequestHeader("Content-type", "application/x-www-form-urlencoded");
	var parameters="tabla=" + tabla + "&campo=" + campo + "&id_nombre=" + id_nombre + "&id_valor=" + id_valor + "&atributo=" + atributo + "&valor=" + valor;
	xmlhttp.send(parameters);
	try { // Aquí va el código de respuesta del servidor. Tu código.
		var jsonresponse=eval('(' + xmlhttp.responseText + ')');
		if (jsonresponse.valor!="Error") return jsonresponse;
	} catch (err){
		alert(err.message);
	}
}

function EstilizaCampos(){
	//var campos=$("*:[data-color=='1']");
	$('*[data-color="1"]').each(function(k, v){
		var attr_arr=RecuperaoEstableceEstilodeCampo($(v).attr('data-tabla'), $(v).attr('data-campo'), $(v).attr('data-id_nombre'), $(v).attr('data-id_valor'), '', 'read');
		$.each(attr_arr, function(a, b){
			$(v).css(b['atributo'], b['valor']);
		});
		//alert($(v).attr('data-tabla'));
	});
}

function isArray(obj){
	return obj.constructor==Array;
}

function spanishDate(d, time){
	if (!time) var time=false;
	var weekday=["Domingo", "Lunes", "Martes", "Miercoles", "Jueves", "Viernes", "Sabado"];
	var monthname=["Enero", "Febrero", "Marzo", "Abril", "Mayo", "Junio", "Julio", "Agosto", "Septiembre", "Octubre", "Noviembre", "Diciembre"];
	if (time) return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear() + " : " + d.getHours() + ":" + d.getMinutes() + ":" + d.getSeconds();
	else
	return weekday[d.getDay()] + " " + d.getDate() + " de " + monthname[d.getMonth()] + " de " + d.getFullYear();
}

function vx_alert(divID, mensaje, titulo, focusafter, width, extraCloseFunc, extraOpenFunc, autoClose, autoClosemSecs){
	if (!focusafter) var focusafter='';
	if (!width) var width='400';
	if (!extraCloseFunc) var extraCloseFunc='';
	if (!extraOpenFunc) var extraOpenFunc='';
	if (!autoClose) var autoClose='NO';
	if (!autoClosemSecs) var autoClosemSecs=4500;
	if (divID!=divIDError && divID!=divIDInfo)
        autoClose='NO';
	else
        globDiv=divID;

	$("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
		stack: false,
		resizable: false,
		width: width,
		title: titulo,
		open: function(event, ui){
		  try {
            $zIndex = 99999;
            $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                $(this).css('z-index',$zIndex++);
            });
            $zIndex-=2;
            $(".ui-widget-overlay").css('z-index',$zIndex);

			if (autoClose=='SI') setTimeout(function(){
				if ($('#' + globDiv).dialog('isOpen')) $('#' + globDiv).dialog('close');
			}, autoClosemSecs);
			if (extraOpenFunc!='')
				eval(extraOpenFunc);

            $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus(); //focus en el botón aceptar.

          } catch (er){ console.log(er); }
			//setTimeout(function(){ $('.ui-dialog :button')[1].focus(); },300); //focus en el botón aceptar.

		},
		close: function(event, ui){
		  try {
            if (extraCloseFunc!='')
				eval(extraCloseFunc);

            if(focusafter!=''){
    			if ($('#' + focusafter).hasClass('selectized')) $('#' + focusafter).selectize()[0].selectize.open();
    			else $('#' + focusafter).focus().select();
            }
			$(this).dialog("destroy");
			$("#" + divID).html('');

            $zIndex = 99999;
            $dS = $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable");
            $zIndex += $dS.length;

            $("div.ui-dialog.ui-corner-all.ui-widget.ui-widget-content.ui-front.ui-dialog-buttons.ui-draggable").each(function(){
                $(this).css('z-index',$zIndex--);
            });
            $(".ui-widget-overlay").css('z-index',$zIndex);
          } catch (er){ console.log(er); };
		},
		buttons: {
			Aceptar: function(){
				$(this).dialog("close");
			}
		}
	});
}

function agregaDiasaFecha(Fecha, Dias, formato){
	if (Dias==0 || Dias=='') return Fecha;
	Dias=parseInt(Dias, 10);
	if (!formato) formato='dmA';
	var CaracterDivisor='-';
	var aFecha=Fecha.split(CaracterDivisor);
	var sDia='';
	var sMes='';
	var sAnio='';
	switch (formato){
	case 'dmA':
		sDia=aFecha[0];
		sMes=aFecha[1];
		sAnio=aFecha[2];
		Fecha=sMes + '-' + sDia + '-' + sAnio;
		var hoy=Date.parse(Fecha);
		var nvaFecha=new Date(hoy);
		nvaFecha.setDate(nvaFecha.getDate() + Dias);
		Fecha=nvaFecha.getDate() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getFullYear();
		break;
	case 'Amd':
		sDia=aFecha[2];
		sMes=aFecha[1];
		sAnio=aFecha[0];
		Fecha=sMes + '-' + sDia + '-' + sAnio;
		var hoy=Date.parse(Fecha);
		var nvaFecha=new Date(hoy);
		nvaFecha.setDate(nvaFecha.getDate() + Dias);
		Fecha=nvaFecha.getFullYear() + '-' + parseInt(nvaFecha.getMonth() + 1, 10) + '-' + nvaFecha.getDate();
		break;
	default:
		break;
	}
	return Fecha;
}
$.fn.makeAbsolute=function(rebase){
	return this.each(function(){
		var el=$(this);
		var pos=el.position();
		el.css({
			position: "absolute",
			marginLeft: 0,
			marginTop: 0,
			top: pos.top,
			left: pos.left
		});
		if (rebase) el.remove().appendTo("body");
	});
};

function getMondayOfCurrentWeek(d){
	var day=d.getDay();
	return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day==0 ? -6 : 1) - day);
}

function getSundayOfCurrentWeek(d){
	var day=d.getDay();
	return new Date(d.getFullYear(), d.getMonth(), d.getDate() + (day==0 ? 0 : 7) - day);
}
//Get the First and Last day of Current Month

function getDayOfMonth(d, dia, mes){
    dia = typeof dia === "undefined" ? "" : dia;
    mes = typeof mes === "undefined" ? "actual" : mes;

    var _day=0, _month=0, _year=0;

    switch(mes)
    {
        case "actual":
            _month = 0;
        break;

        case "pasado":
            _month = -1;
        break;

        case "proximo":
            _month = 1;
        break;

        default:
            _month = 0;
        break;

    }

    switch(dia)
    {
        case "primero":
            _day = 1;
        break;

        case "ultimo":
            _day = 0;
            _month++;
        break;

        default:
            _day = 0;
        break;
    }

	return new Date(d.getFullYear() + _year, d.getMonth() + _month, _day);
}

function getFistDayOfCurrentMonth(d){
	return new Date(d.getFullYear(), d.getMonth(), 1);
}


function getLastDayOfCurrentMonth(d){
	return new Date(d.getFullYear(), d.getMonth() + 1, 0);
}

function getLastXDays(d,days){
    return new Date(d.getFullYear(), d.getMonth(), d.getDate() - days);
}

function buildStringwithDelimeters(str, origDelim, finalDelim, campoID, paraSQL, colSQL){
	var finalStr='',
		tmpArr,
        matchAg = gridhandler.attr('id').search('pagare') >=0 ? true : false;


	if (!origDelim) var origDelim=',';
	if (!finalDelim) var finalDelim=' ';
	if (!paraSQL) var paraSQL='NO';
	if (!campoID){
		var campoID='';
		tmpArr=str.split(origDelim);
	} else if (campoID.length && paraSQL=='SI'){
		if ($('#' + campoID + '_and').is(':checked')) finalDelim=' AND ';
		else if ($('#' + campoID + '_or').is(':checked')) finalDelim=' OR ';
		tmpArr=$('#' + campoID).val().split(origDelim);
	}
	$.each(tmpArr, function(k, v){
		if (paraSQL=='SI')
            if(matchAg && colSQL.search('remarks') >=0)
                finalStr=finalStr + " MATCH (" + colSQL + "_wot) AGAINST ('" + v.trim() + "') " + finalDelim;
            else
                finalStr=finalStr + " " + colSQL + " LIKE '%25" + v.trim() + "%25' " + finalDelim;
		else
		  finalStr=finalStr + v.trim() + finalDelim;
	});
	finalStr=finalStr.substring(0, finalStr.length - finalDelim.length);
	return finalStr;
}

function pad(width, string, padding){
	return (width <= string.length) ? string : pad(width, padding + string, padding)
}

function vx_confirmNONONO(divID, mensaje, titulo, yesFunc, noFunc){
	var width='400';
	if (!noFunc) var noFunc='';
	if (!yesFunc) var yesFunc='';
	$("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
		modal: true,
		resizable: false,
		width: width,
		title: titulo,
		open: function(event, ui){},
		close: function(event, ui){
			$(this).dialog("destroy");
			$("#" + divID).html('');
		},
		buttons: {
			'Sí': function(){
				if (yesFunc!='') try {
					eval(yesFunc);
				} catch (er){
					console.log(er);
				}
				$(this).dialog("close");
			},
			'No': function(){
				if (noFunc!='') try {
					eval(noFunc);
				} catch (er){
					console.log(er);
				}
				$(this).dialog("close");
			}
		}
	});
}

function obtenComparador(str, tipo, val){
	if (!tipo) var tipo='num';
	if (!str || str.length==0) return '=';
	var co='';
	if (tipo=='num') switch (str){
	case'eq':co='=';break;
	case'ne':co='!=';break;
	case'lt':co='<';break;
	case'le':co='<=';break;
	case'gt':co='>';break;
	case 'ge':co='>=';break;
	default:co='=';break;
	} else switch (str){
	case 'eq':co=" LIKE '" + val + "%25' ";break;
	case 'ne':co=" NOT LIKE '" + val + "%25' ";break;
	case 'lt':co=" < '" + val + " 00:00:00' ";break;
	case 'le':co=" <= '" + val + " 23:59:59' ";break;
	case 'gt':co=" > '" + val + " 23:59:59' ";break;
	case 'ge':co=" >= '" + val + " 00:00:00' ";break;
	default:co=" LIKE '" + val + "%25' ";break;
	}
	return co;
}

function parseVxFloat(str){
    return vx_utils.parseFloat(str);
}


function vx_confirm(divID, mensaje, titulo, yesCallbackFunc, noCallbackFunc, width){
    divID=divID===undefined?'IA_INFO':divID;
    mensaje=mensaje===undefined?'':mensaje;
    titulo=titulo===undefined?'':titulo;
    width=width===undefined?'400':width;
    yesCallbackFunc=yesCallbackFunc===undefined?function(){return;}:yesCallbackFunc;
    noCallbackFunc=noCallbackFunc===undefined?function(){return;}:noCallbackFunc;


	$("#" + divID).html('<br><br>' + mensaje + '<br><br>').dialog({
        modal: true,
		resizable: false,
		width: width,
		title: titulo,
		open: function(event, ui){
            try{ $(this).siblings('.ui-dialog-buttonpane').find('button')[0].focus(); }
            catch(er){ console.log(er); }
		},
		close: function(event, ui){
            try{
    			$(this).dialog("destroy");
    			$("#" + divID).html('');
            }catch(er){ console.log(er); }
		},
		buttons: {
            "Sí": function(){
                try{ yesCallbackFunc(); }
                catch(er){ console.log(er); }
				$(this).dialog("close");
			},
            "No": function(){
                try{ noCallbackFunc(); }
                catch(er){ console.log(er); }
				$(this).dialog("close");
			}
		}
	});
}

function vx_confirmation(question) {
    var defer = $.Deferred();
    $('<div></div>')
        .html(question)
        .dialog({
            autoOpen: true,
            modal: true,
            title: 'Por favor, confirma:',
            buttons: {
                "Sí": function () {
                    defer.resolve("true");//this text 'true' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                },
                "No": function () {
                    defer.resolve("false");//this text 'false' can be anything. But for this usage, it should be true or false.
                    $(this).dialog("close");
                }
            },
            close: function () {
                $(this).remove();
            }
        });
    return defer.promise();
}

function vx_parseFloat(str){
    return vx_utils.parseFloat(str);
}

function strip_tags(str)
{
    if(!str || !str.length)
        return '';
    return str.replace(/<[^>]+>/g, '');
}

/**
 * Cross file utilities for working with arrays,
 * sorting and other fun stuff
 * @return {Object} vx_utils
 */
var vx_utils = {};
window.fbLoaded = {
  js: [],
  css: [],
}
window.fbEditors = {
  quill: {},
  tinymce: {},
}

// cleaner syntax for testing indexOf element
vx_utils.inArray = function(needle, haystack) {
  return haystack.indexOf(needle) !== -1
}

/**
   * Remove null or undefined values
   * @param  {Object} attrs {attrName: attrValue}
   * @return {Object}       Object trimmed of null or undefined values
   */
vx_utils.trimObj = function(attrs) {
  let xmlRemove = [null, undefined, '', false, 'false']
  for (let attr in attrs) {
    if (vx_utils.inArray(attrs[attr], xmlRemove)) {
      delete attrs[attr]
    } else if (Array.isArray(attrs[attr])) {
      if (!attrs[attr].length) {
        delete attrs[attr]
      }
    }
  }

  return attrs
}

/**
   * Test if attribute is a valid HTML attribute
   * @param  {String} attr
   * @return {Boolean}
   */
vx_utils.validAttr = function(attr) {
  let invalid = [
    'values',
    'enableOther',
    'other',
    'label',
    // 'style',
    'subtype',
  ]
  return !vx_utils.inArray(attr, invalid)
}

/**
   * Convert an attrs object into a string
   *
   * @param  {Object} attrs object of attributes for markup
   * @return {string}
   */
vx_utils.attrString = function(attrs) {
  let attributes = []

  for (let attr in attrs) {
    if (attrs.hasOwnProperty(attr) && vx_utils.validAttr(attr)) {
      attr = vx_utils.safeAttr(attr, attrs[attr])
      attributes.push(attr.name + attr.value)
    }
  }
  return attributes.join(' ')
}

/**
   * Convert attributes to markup safe strings
   * @param  {String} name  attribute name
   * @param  {String} value attribute value
   * @return {Object}       {attrName: attrValue}
   */
vx_utils.safeAttr = function(name, value) {
  name = vx_utils.safeAttrName(name)
  let valString

  if (value) {
    if (Array.isArray(value)) {
      valString = vx_utils.escapeAttr(value.join(' '))
    } else {
      if (typeof value === 'boolean') {
        value = value.toString()
      }
      valString = vx_utils.escapeAttr(value.replace(',', ' ').trim())
    }
  }

  value = value ? `="${valString}"` : ''
  return {
    name,
    value,
  }
}

vx_utils.safeAttrName = function(name) {
  let safeAttr = {
    className: 'class',
  }

  return safeAttr[name] || vx_utils.hyphenCase(name)
}

/**
   * Convert strings into lowercase-hyphen
   *
   * @param  {String} str
   * @return {String}
   */
vx_utils.hyphenCase = str => {
  str = str.replace(/[^\w\s\-]/gi, '')
  str = str.replace(/([A-Z])/g, function($1) {
    return '-' + $1.toLowerCase()
  })

  return str.replace(/\s/g, '-').replace(/^-+/g, '')
}

/**
   * convert a hyphenated string to camelCase
   * @param  {String} str
   * @return {String}
   */
vx_utils.camelCase = str => str.replace(/-([a-z])/g, (m, w) => w.toUpperCase())

/**
   * Determine content type
   * @param  {Node | String | Array | Object} content
   * @return {String}                         contentType for mapping
   */
vx_utils.contentType = content => {
  let type = typeof content
  if (content instanceof Node || content instanceof HTMLElement) {
    type = 'node'
  } else if (Array.isArray(content)) {
    type = 'array'
  }

  return type
}

/**
   * Bind events to an element
   * @param  {Object} element DOM element
   * @param  {Object} events  object full of events eg. {click: evt => callback}
   * @return {void}
   */
vx_utils.bindEvents = (element, events) => {
  if (events) {
    for (let event in events) {
      if (events.hasOwnProperty(event)) {
        element.addEventListener(event, evt => events[event](evt))
      }
    }
  }
}

/**
 * Generate a unique name attribute
 * @param  {Object} field
 * @return {String}       name
 */
vx_utils.nameAttr = function(field) {
  let epoch = new Date().getTime()
  let prefix = field.type || vx_utils.hyphenCase(field.label)
  return prefix + '-' + epoch
}

/**
   * Generate markup wrapper where needed
   *
   * @param  {string}              tag
   * @param  {String|Array|Object} content we wrap this
   * @param  {Object}              attributes
   * @return {Object} DOM Element
   */
vx_utils.markup = function(tag, content = '', attributes = {}) {
  let contentType = vx_utils.contentType(content)
  let { events, ...attrs } = attributes
  const field = document.createElement(tag)

  const appendContent = {
    string: content => {
      field.innerHTML += content
    },
    object: config => {
      let { tag, content, ...data } = config
      return field.appendChild(vx_utils.markup(tag, content, data))
    },
    node: content => {
      return field.appendChild(content)
    },
    array: content => {
      for (let i = 0; i < content.length; i++) {
        contentType = vx_utils.contentType(content[i])
        appendContent[contentType](content[i])
      }
    },
    function: content => {
      content = content()
      contentType = vx_utils.contentType(content)
      appendContent[contentType](content)
    },
    undefined: () => {
    },
  }

  for (let attr in attrs) {
    if (attrs.hasOwnProperty(attr)) {
      let name = vx_utils.safeAttrName(attr)
      field.setAttribute(name, attrs[attr])
    }
  }

  if (content) {
    appendContent[contentType].call(this, content)
  }

  vx_utils.bindEvents(field, events)

  return field
}

/**
   * Convert html element attributes to key/value object
   * @param  {Object} elem DOM element
   * @return {Object} ex: {attrName: attrValue}
   */
vx_utils.parseAttrs = elem => {
  let attrs = elem.attributes
  let data = {}
  vx_utils.forEach(attrs, attr => {
    let attrVal = attrs[attr].value || ''
    if (attrVal.match(/false|true/g)) {
      attrVal = attrVal === 'true'
    } else if (attrVal.match(/undefined/g)) {
      attrVal = undefined
    }

    if (attrVal) {
      data[attrs[attr].name] = attrVal
    }
  })

  return data
}

/**
   * Convert field options to optionData
   * @param  {NodeList} options  DOM elements
   * @return {Array} optionData array
   */
vx_utils.parseOptions = options => {
  let optionData = {}
  let data = []

  for (let i = 0; i < options.length; i++) {
    optionData = vx_utils.parseAttrs(options[i])
    optionData.label = options[i].textContent
    data.push(optionData)
  }

  return data
}

/**
   * Parse XML formData
   * @param  {String} xmlString
   * @return {Array}            formData array
   */
vx_utils.parseXML = xmlString => {
  const parser = new window.DOMParser()
  let xml = parser.parseFromString(xmlString, 'text/xml')
  let formData = []

  if (xml) {
    let fields = xml.getElementsByTagName('field')
    for (let i = 0; i < fields.length; i++) {
      let fieldData = vx_utils.parseAttrs(fields[i])
      const options = fields[i].getElementsByTagName('option')

      if (options && options.length) {
        fieldData.values = vx_utils.parseOptions(options)
      }

      formData.push(fieldData)
    }
  }

  return formData
}

/**
   * Converts escaped HTML into usable HTML
   * @param  {String} html escaped HTML
   * @return {String}      parsed HTML
   */
vx_utils.parsedHtml = html => {
  let escapeElement = document.createElement('textarea')
  escapeElement.innerHTML = html
  return escapeElement.textContent
}

/**
   * Escape markup so it can be displayed rather than rendered
   * @param  {String} html markup
   * @return {String}      escaped html
   */
vx_utils.escapeHtml = html => {
  let escapeElement = document.createElement('textarea')
  escapeElement.textContent = html
  return escapeElement.innerHTML
}

// Escape an attribute
vx_utils.escapeAttr = str => {
  let match = {
    '"': '&quot;',
    '&': '&amp;',
    '<': '&lt;',
    '>': '&gt;',
  }

  const replaceTag = tag => match[tag] || tag

  return typeof str === 'string' ? str.replace(/["&<>]/g, replaceTag) : str
}

// Escape attributes
vx_utils.escapeAttrs = attrs => {
  for (let attr in attrs) {
    if (attrs.hasOwnProperty(attr)) {
      attrs[attr] = vx_utils.escapeAttr(attrs[attr])
    }
  }

  return attrs
}

// forEach that can be used on nodeList
vx_utils.forEach = function(array, callback, scope) {
  for (let i = 0; i < array.length; i++) {
    callback.call(scope, i, array[i]) // passes back stuff we need
  }
}

/**
   * Remove duplicates from an array of elements
   * @param  {Array} array  array with possible duplicates
   * @return {Array}        array with only unique values
   */
vx_utils.unique = array => {
  return array.filter((elem, pos, arr) => arr.indexOf(elem) === pos)
}

/**
   * Removes a value from an array
   * @param  {String|Number} val
   * @param  {Array} arr
   */
vx_utils.remove = (val, arr) => {
  let index = arr.indexOf(val)

  if (index > -1) {
    arr.splice(index, 1)
  }
}

/**
   * Loads an array of scripts using jQuery's `getScript`
   * @param  {Array|String}  scriptScr    scripts
   * @param  {String} path   optional to load form
   * @return {Promise}       a promise
   */
vx_utils.getScripts = (scriptScr, path) => {
  const $ = jQuery
  let _arr = []

  if (!Array.isArray(scriptScr)) {
    scriptScr = [scriptScr]
  }

  if (!vx_utils.isCached(scriptScr)) {
    _arr = $.map(scriptScr, src => {
      let options = {
        dataType: 'script',
        cache: true,
        url: (path || '') + src,
      }
      return $.ajax(options).done(() => window.fbLoaded.js.push(src))
    })
  }

  _arr.push($.Deferred(deferred => $(deferred.resolve)))

  return $.when(..._arr)
}

/**
   * Checks if remote resource is already loaded
   * @param  {String|Array} src  url of remote script or css
   * @param  {String}       type       'js' or 'css'
   * @return {Boolean}      isCached
   */
vx_utils.isCached = (src, type = 'js') => {
  let isCached = false
  const cache = window.fbLoaded[type]
  if (Array.isArray(src)) {
    isCached = src.every(s => vx_utils.inArray(s, cache))
  } else {
    isCached = vx_utils.inArray(src, cache)
  }
  return isCached
}

/**
   * Appends stylesheets to the head
   * @param  {Array} scriptScr
   * @param  {String} path
   * @return {void}
   */
vx_utils.getStyles = (scriptScr, path) => {
  if (!Array.isArray(scriptScr)) {
    scriptScr = [scriptScr]
  }
  scriptScr.forEach(src => {
    // if a string is passed, assume a href URL
    let type = 'href'
    let key = src
    let id = ''

    // if an object is passed, work out details from it's properties
    if (typeof src == 'object') {
      type = src.type || (src.style ? 'inline' : 'href')
      id = src.id
      src = type == 'inline' ? src.style : src.href
      key = id || src.href || src.style
    }

    // check we haven't already loaded this css
    if (vx_utils.isCached(key, 'css')) {
      return
    }

    // append the style into the head
    if (type == 'href') {
      let link = document.createElement('link')
      link.type = 'text/css'
      link.rel = 'stylesheet'
      link.href = (path || '') + src
      document.head.appendChild(link)
    } else {
      $(`<style type="text/css">${src}</style>`)
        .attr('id', id)
        .appendTo($(document.head))
    }

    // record this is cached
    window.fbLoaded.css.push(key)
  })
}

/**
 * Capitalizes a string
 * @param  {String} str uncapitalized string
 * @return {String} str capitalized string
 */
vx_utils.capitalize = str => {
  return str.replace(/\b\w/g, function(m) {
    return m.toUpperCase()
  })
}

vx_utils.merge = (obj1, obj2) => {
  let mergedObj = Object.assign({}, obj1, obj2)
  for (let prop in obj2) {
    if (mergedObj.hasOwnProperty(prop)) {
      if (Array.isArray(obj2[prop])) {
        mergedObj[prop] = Array.isArray(obj1[prop]) ? vx_utils.unique(obj1[prop].concat(obj2[prop])) : obj2[prop]
      } else if (typeof obj2[prop] === 'object') {
        mergedObj[prop] = vx_utils.merge(obj1[prop], obj2[prop])
      } else {
        mergedObj[prop] = obj2[prop]
      }
    }
  }
  return mergedObj
}

vx_utils.addEventListeners = (el, evts, fn) => {
  return evts.split(' ').forEach(e => el.addEventListener(e, fn, false))
}

/**
 * Find the closest parent by class
 * @param  {Object} el  DOM element
 * @param  {String} cls class
 * @return {Object}     DOM Element
 */
vx_utils.closest = (el, cls) => {
  let className = cls.replace('.', '')
  while ((el = el.parentElement) && !el.classList.contains(className));
  return el
}

vx_utils.noop = () => null

/**
 * Debounce often called functions, like save
 * @param  {Function}  func
 * @param  {Number}  wait
 * @param  {Boolean} immediate
 * @return {Function} debounce
 */
vx_utils.debounce = (func, wait = 250, immediate = false) => {
  let timeout
  return function(...args) {
    // eslint-disable-next-line no-invalid-this
    let context = this
    let later = function() {
      timeout = null
      if (!immediate) {
        func.apply(context, args)
      }
    }
    let callNow = immediate && !timeout
    clearTimeout(timeout)
    timeout = setTimeout(later, wait)
    if (callNow) {
      func.apply(context, args)
    }
  }
}

/**
 * Add a mobile class
 * @todo find css only solution
 * @return {String} Mobile class added to formBuilder
 */
vx_utils.mobileClass = () => {
  let mobileClass = ''
  ;(a => {
    // eslint-disable-next-line
    if (
      /(android|bb\d+|meego).+mobile|avantgo|bada\/|blackberry|blazer|compal|elaine|fennec|hiptop|iemobile|ip(hone|od)|iris|kindle|lge |maemo|midp|mmp|mobile.+firefox|netfront|opera m(ob|in)i|palm( os)?|phone|p(ixi|re)\/|plucker|pocket|psp|series(4|6)0|symbian|treo|up\.(browser|link)|vodafone|wap|windows ce|xda|xiino/i.test(
        a
      ) ||
      /1207|6310|6590|3gso|4thp|50[1-6]i|770s|802s|a wa|abac|ac(er|oo|s\-)|ai(ko|rn)|al(av|ca|co)|amoi|an(ex|ny|yw)|aptu|ar(ch|go)|as(te|us)|attw|au(di|\-m|r |s )|avan|be(ck|ll|nq)|bi(lb|rd)|bl(ac|az)|br(e|v)w|bumb|bw\-(n|u)|c55\/|capi|ccwa|cdm\-|cell|chtm|cldc|cmd\-|co(mp|nd)|craw|da(it|ll|ng)|dbte|dc\-s|devi|dica|dmob|do(c|p)o|ds(12|\-d)|el(49|ai)|em(l2|ul)|er(ic|k0)|esl8|ez([4-7]0|os|wa|ze)|fetc|fly(\-|_)|g1 u|g560|gene|gf\-5|g\-mo|go(\.w|od)|gr(ad|un)|haie|hcit|hd\-(m|p|t)|hei\-|hi(pt|ta)|hp( i|ip)|hs\-c|ht(c(\-| |_|a|g|p|s|t)|tp)|hu(aw|tc)|i\-(20|go|ma)|i230|iac( |\-|\/)|ibro|idea|ig01|ikom|im1k|inno|ipaq|iris|ja(t|v)a|jbro|jemu|jigs|kddi|keji|kgt( |\/)|klon|kpt |kwc\-|kyo(c|k)|le(no|xi)|lg( g|\/(k|l|u)|50|54|\-[a-w])|libw|lynx|m1\-w|m3ga|m50\/|ma(te|ui|xo)|mc(01|21|ca)|m\-cr|me(rc|ri)|mi(o8|oa|ts)|mmef|mo(01|02|bi|de|do|t(\-| |o|v)|zz)|mt(50|p1|v )|mwbp|mywa|n10[0-2]|n20[2-3]|n30(0|2)|n50(0|2|5)|n7(0(0|1)|10)|ne((c|m)\-|on|tf|wf|wg|wt)|nok(6|i)|nzph|o2im|op(ti|wv)|oran|owg1|p800|pan(a|d|t)|pdxg|pg(13|\-([1-8]|c))|phil|pire|pl(ay|uc)|pn\-2|po(ck|rt|se)|prox|psio|pt\-g|qa\-a|qc(07|12|21|32|60|\-[2-7]|i\-)|qtek|r380|r600|raks|rim9|ro(ve|zo)|s55\/|sa(ge|ma|mm|ms|ny|va)|sc(01|h\-|oo|p\-)|sdk\/|se(c(\-|0|1)|47|mc|nd|ri)|sgh\-|shar|sie(\-|m)|sk\-0|sl(45|id)|sm(al|ar|b3|it|t5)|so(ft|ny)|sp(01|h\-|v\-|v )|sy(01|mb)|t2(18|50)|t6(00|10|18)|ta(gt|lk)|tcl\-|tdg\-|tel(i|m)|tim\-|t\-mo|to(pl|sh)|ts(70|m\-|m3|m5)|tx\-9|up(\.b|g1|si)|utst|v400|v750|veri|vi(rg|te)|vk(40|5[0-3]|\-v)|vm40|voda|vulc|vx(52|53|60|61|70|80|81|83|85|98)|w3c(\-| )|webc|whit|wi(g |nc|nw)|wmlb|wonu|x700|yas\-|your|zeto|zte\-/i.test(
        a.substr(0, 4)
      )
    ) {
      mobileClass = ' fb-mobile'
    }
  })(navigator.userAgent || navigator.vendor || window.opera)
  return mobileClass
}

/**
 * Convert converts messy `cl#ssNames` into valid `class-names`
 *
 * @param  {String} str
 * @return {String} hyphenated string
 */
vx_utils.makeClassName = str => {
  return vx_utils.hyphenCase(str.replace(/[^\w\s\-]/gi, ''))
}

/**
 * Make strings safe to be used as classes
 *
 * @param  {String} str string to be converted
 * @return {String}     converter string
 */
vx_utils.safename = str => {
  return str
    .replace(/\s/g, '-')
    .replace(/[^a-zA-Z0-9\[\]\_-]/g, '')
    .toLowerCase()
}

/**
 * Strips non-numbers from a number only input
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.forceNumber = str => {
  return str.replace(/[^0-9]/g, '')
}
/**
 * Converts a string into a float number.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseFloat = str => {
    if(typeof str === "string")
        if(!str || str.length===0)
            return 0.00;
        else
            str = parseFloat(str.replace(/[^0-9.]+/g, '').trim()); //.replace(/\,|\$| /g,'')
    return isNaN(str) ? 0.00 : str;
}
/**
 * Converts a string into an int number.
 *
 * @param  {string} str string with possible number
 * @return {string}     string without non-numbers
 */
vx_utils.parseInt = str => {
    if(typeof str === "string")
        if(!str || str.length===0)
            return 0;
        else
            str = parseInt(str.replace(/[^0-9.]+/g, '').trim()); //.replace(/\,|\$| /g,'')
    return isNaN(str) ? 0 : str;
}
/**
 * Adds slashes like PHP.
 *
 * @param  {string} str string
 * @return {string}     string with slashes
 */
vx_utils.addslashes = str => {
    if(!str || str.length===0)
        return "";
    return str.replace(/\\/g, '\\\\').
        replace(/\u0008/g, '\\b').
        replace(/\t/g, '\\t').
        replace(/\n/g, '\\n').
        replace(/\f/g, '\\f').
        replace(/\r/g, '\\r').
        replace(/'/g, '\\\'').
        replace(/"/g, '\\"');
}

/**
 * Camelliza una cadena de caracteres.
 *
 * @param  {string} str string
 * @return {string}     string camellizado
 */
vx_utils.toCamelCase = str => {
    if(!str || str.length===0)
        return "";
  return str.replace(/\w\S*/g, function(txt){return txt.charAt(0).toUpperCase() + txt.substr(1).toLowerCase();});
}

ia.alert = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    var defer = $.Deferred(), m=messageIconSpan==null ? '' : messageIconSpan+' ';
    $('<div/>')
        .html(m+(html===true ? message : message.replace(/</g,'&lt; '))).addClass(addClass==null ? '' : addClass)
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Aviso' : title,
            buttons: [
                {text:buttonText==null ? 'Ok' : buttonText,icon:buttonIcon==null ? 'ui-icon-check' : buttonIcon,
                 click:function(e){
                    e.target.disabled = true;
                    if(!defer.isResolved && !defer.isRejected)
                        defer.resolve("true");
                    $(this).dialog("close");
                 }
                },
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
};
ia.alertHighlight = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-info"></span>':messageIconSpan, addClass==null ? 'ui-state-highlight' : addClass, buttonText, buttonIcon);
};
ia.alertInfo = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-info"></span>':messageIconSpan, addClass, buttonText, buttonIcon);
};
ia.alertWarn = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-alert"></span>':messageIconSpan, addClass, buttonText, buttonIcon);
};
ia.alertError = function(message, title, html, messageIconSpan, addClass, buttonText, buttonIcon) {
    return ia.alert(message, title, html, messageIconSpan==null ? '<span class="ui-icon ui-icon-alert"></span>':messageIconSpan,addClass==null ? 'ui-state-error-text' : addClass, buttonText, buttonIcon);
};

ia.confirm = function(message, title, html) {
    var defer = $.Deferred();
    $('<div/>')
        .html(html===true ? message : message.replace(/</g,'&lt; '))
        .dialog({
            autoOpen:true,
            resizable:true,
            draggable:true,
            modal:true,
            closeOnEscape:true,
            width:'auto',
            height:'auto',
            title: title==null ? 'Por favor, confirma:' : title,
            buttons: [
                {text:'Si',icon:'ui-icon-check',
                 click:function(e){
                    e.target.disabled = true;
                    if(!defer.isResolved && !defer.isRejected)
                        defer.resolve("true");
                    $(this).dialog("close");
                 }
                },
                {text:'No',icon:'ui-icon-cancel',
                 click:function(e){
                    e.target.disabled = true;
                    if(!defer.isResolved && !defer.isRejected)
                        defer.reject();
                    $(this).dialog("close");
                 }
                }
            ],
            close: function () {
                if(!defer.isResolved && !defer.isRejected)
                    defer.reject();
                $(this).dialog('destroy').remove();
            }
        });
    return defer.promise();
};

ia.confirmDelete = function(message,title,html){
    var defer = $.Deferred();
    $("<div />").html('<span class="ui-icon ui-icon-trash"></span> ' + (html===true ? message : message.replace(/</g,'&lt; '))).addClass('ui-state-error-text')
    .dialog({
        autoOpen:true,
        resizable:true,
        draggable:true,
        modal:true,
        closeOnEscape:true,
        width:'auto',
        height:'auto',
        title: title==null ? 'Confirme Eliminar:' : title,
        buttons: [
            {text: "Eliminar",icon:"ui-icon-trash",'class':"ui-state-error-text",
                click: function(e) {
                    e.target.disabled = true;
                    if(!defer.isResolved && !defer.isRejected)
                        defer.resolve("true");
                    $(this).dialog("close");
                }
            },
            {text:'Cancelar',icon:'ui-icon-cancel',
                click:function(e){
                    e.target.disabled = true;
                    if(!defer.isResolved && !defer.isRejected)
                        defer.reject();
                    $(this).dialog("close");
                }
            }
        ],
        close: function () {
            if(!defer.isResolved && !defer.isRejected)
                defer.reject();
            $(this).dialog('destroy').remove();
        }
    });
    return defer.promise();
};

ia.tagProtect = function(html) {
    var tags=['script','object','embed','iframe','frame','applet','button','input','form','base','param']   ;
    for(var i=0,tagsLen=tags.length; i<tagsLen; i++ ) {
        var regExp = new RegExp( '<(' + tags[i] + ')|<\/(' + tags[i] +')', 'gimu');
        html = html.replace(regExp, ' $1 /$2');
    }
    return html;
}

ia.textWidth = function(text,addClass){
     var calc = $('<span style="display:none">' + text + '</span>');
     if(typeof addClass!=='undefined')
        calc.addClass(addClass);
     else
        calc.addClass('ui-dialog-title-bar ui-widget-header ui-dialog-title'); // add 46 for dialog width
     $('body').append(calc);
     var width = calc.width();
     calc.remove();
     return width;
}

$.fn.reverse = [].reverse;

$.fn.ia = $.fn.ia || {};
$.fn.muestra = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.css('visibility')==='hidden')
            e.css({'visibility':'visible'}).data('iavisibility',1);
        if(e.css('display')==='none')
            if(wa)
                e.show(args);
            else
                e.show();
    });
};

$.fn.oculta = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        var e = $(this);
        if(e.data('iavisibility')=='1')
            e.css({'visibility':'hidden'});
        else if(wa)
            e.hide(arguments);
        else
            e.hide();
    });
};

$.fn.muestraConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).muestra();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.muestra();
    });
};
$.fn.ocultaConLabel = function() {
    var args = arguments, wa=args.length>0;
    return this.each(function() {
        $(this).oculta();
        var lbl = $("label[for='"+this.id+"']");
        if(lbl.length>0)
            lbl.oculta();
    });
};

$.fn.isHidden = function () {
    if(this.length === 1) {
        var el = $(this);
        return el.css('display')==='none' || el.css('visibility')==='hidden';
    }
    var r={};
    this.each(function() {
        var el = $(this);
        if(typeof el.type !== 'undefined' && el.type==='hidden')
            r = false;
        r = el.css('display')==='none' || el.css('visibility')==='hidden';
    });
    return r;
};

$.fn.valVisible = function(onHiddenReturn) {
    // only visible, onhidden dflt, unchecked checkedbox,
    // $("#valeIncome").find("INPUT").valVisible()
    var e = $(this);
    if(e.length === 0)
        return;
    var ret=[];
    this.each(function() {
        var e = $(this), name=e.attr('name'), r={};
        if(typeof name==='string' && name.length>0) {
            if(e.isHidden())
                r[this.id] = typeof onHiddenReturn === 'undefined' ? 0.00 : onHiddenReturn;
            else
                r[this.id] = myval(e);
            ret[ret.length] = r;
        }
    });
    return ret;
    function myval(el) {
        if(el.attr('type')==='checkbox' || el.attr('type')==='radio')
            if(el.prop('checked'))
                return el.val();
            else
                return;
        if(typeof el.data('autoNumeric') !== 'undefined')
            return el.autoNumeric('get');
        return el.val();
    }
};

(function($, window, document, undefined) {

    /**
     * Store the plugin name in a variable. It helps you if later decide to
     * change the plugin's name
     * @type {String}
     */
    var pluginName = 'vx_autoDateCheckBox';

    /**
     * The plugin constructor
     * @param {DOM Element} element The DOM element where plugin is applied
     * @param {Object} options Options passed to the constructor
     */
    function Plugin(element, options) {

        // Store a reference to the source element
        this.el = element;

        // Store a jQuery reference  to the source element
        this.$el = $(element);

        // Set the instance options extending the plugin defaults and
        // the options passed by the user
        this.options = $.extend({}, $.fn[pluginName].defaults, options);

        // Initialize the plugin instance
        this.init();
    }

    /**
     * Set up your Plugin prototype with desired methods.
     * It is a good practice to implement 'init' and 'destroy' methods.
     */
    Plugin.prototype = {

        /**
         * Initialize the plugin instance.
         * Set any other attribtes, store any other element reference, register
         * listeners, etc
         *
         * When bind listerners remember to name tag it with your plugin's name.
         * Elements can have more than one listener attached to the same event
         * so you need to tag it to unbind the appropriate listener on destroy:
         *
         * @example
         * this.$someSubElement.on('click.' + pluginName, function() {
         *      // Do something
         * });
         *
         */
        init: function() {
            var $me = this,
            $elem = $me.$el,
            $doWrap = $elem.data('dowrap'),
            $id = $elem.data('input'),
            $field = $elem.data('field'),
            $a={}, $fs_id=$id+'_bt_fs', $minime={};

            $field = $field.split(",");

            $me.options.tipodeBusqueda = typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
            $me.options.instances[$id] = {};
            $minime = $me.options.instances[$id];
            $minime.input = $id;
            $minime.field = $field;
            $minime.xtrasqlpre = $elem.data('xtrasqlpre') === undefined ? "" : $elem.data('xtrasqlpre');
            $minime.xtrasqlpost = $elem.data('xtrasqlpost') === undefined ? "" : $elem.data('xtrasqlpost');
            $minime.sqlString = "";

            $minime.ifields = {
                f_fechaIni : $id + "_ini",
                f_fechaFin : $id + "_fin",
                f_horaIni : $id + "_time_ini",
                f_horaFin : $id + "_time_fin",
            };



            if($doWrap == 'Si')
            {
                var $div = $('<div />',{
                    'class':"dved",
                    'style':"display: inline; float: left;"
                }),
                $fs = $('<fieldset />',{
                    'name':$fs_id,
                    'class':"busqueda_access ba_dates",
                    'id':$fs_id
                }),
                $le = $('<legend />').text($elem.data('title')),
                $table = $('<table />',{
                    'style':"width: 100%",
                }), $place;
                $tmpHtml = '';

                $tmpHtml += '<tr><td><label for="'+$minime.ifields.f_fechaIni+'">Between</label>';
                $tmpHtml += '<td><input name="'+$minime.ifields.f_fechaIni+'" id="'+$minime.ifields.f_fechaIni+'" type="text" autocomplete="off" size="15" maxlength="14" class="datepicker" />';
                $tmpHtml += '<td><input name="'+$minime.ifields.f_horaIni+'" id="'+$minime.ifields.f_horaIni+'" type="text" autocomplete="off" size="5" class="auto" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';
                $tmpHtml += '<tr><td><label for="'+$minime.ifields.f_fechaFin+'">and</label>';
                $tmpHtml += '<td><input name="'+$minime.ifields.f_fechaFin+'" id="'+$minime.ifields.f_fechaFin+'" type="text" autocomplete="off" size="15" maxlength="14" class="datepicker" />';
                $tmpHtml += '<td><input name="'+$minime.ifields.f_horaFin+'" id="'+$minime.ifields.f_horaFin+'" type="text" autocomplete="off" size="5" class="auto" data-autonumeric="{mNum:2,mDec:0,vMin:0,vMax:24}" />';

                $place = $($elem.siblings('div')[0]);

                $table.append($tmpHtml);


                $fs.append($le);
                $fs.append($table);
                $fs.append($elem);
                $div.append($fs);

                $place.after($div);

                setTimeout(function(){
                    init_autoNumeric($id+'_bt_fs');
                    init_datepicker($id+'_bt_fs');
                    $.each($minime.ifields, function(k,v){
                        $('#'+v).on('change', function(){
                            $me._buildSQLString();
                        });
                    })
                }, 100);
            }

            $a = $('<a />', {
                href:'javascript:void(0);',
                'class':'vx_adcb_limpia',
            }).append($('<img />', {
                src:'../img/16-refresh.png',
                title:'Limpiar'
            })).on('click', function(){
                var $tmp = $('#'+$fs_id).find('input');//$elem.parent().find('input');
                $tmp.filter("[type=text]").val('');
                $tmp.filter("[type=radio]").prop('checked', false);
                $me._buildSQLString();
            });

            $elem.after($a);

            $minime.icbs = [];
            $($me.options.cbs).reverse().each(function(k,v){
                var icbsid = $id + this.nombre, tmpel = {}, tmplbl = {};
                $minime.icbs[icbsid] = {
                    fn : this.fn
                    ,fi : this.fi
                    ,ff : this.ff
                };
                tmpel = $('<input />', {
                     id:    icbsid
                    ,name:  $id + "_vx_autoDateCheckBox"
                    ,value: 'ON'
                    ,type:  'radio'
                    ,checked:false
                    ,'class':"vx_adcb_class"
                }).on('change', function(){
                    $('#'+$minime.ifields.f_fechaIni).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].fi]);
                    $('#'+$minime.ifields.f_fechaFin).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].ff]);
                    $me._buildSQLString();
                });

                tmplbl = $('<label />', { 'for': icbsid, 'class':"vx_adcb_class" }).html(this.label + '&nbsp;&nbsp;');

                $elem.after(tmplbl).after(tmpel);
                if(k<4&&((k+1)%3==0))
                    $elem.after("<br/>");
            });
        },

        /**
         * The 'destroy' method is were you free the resources used by your plugin:
         * references, unregister listeners, etc.
         *
         * Remember to unbind for your event:
         *
         * @example
         * this.$someSubElement.off('.' + pluginName);
         *
         * Above example will remove any listener from your plugin for on the given
         * element.
         */
        destroy: function() {

            // Remove any attached data from your plugin
            this.$el.removeData();
        },

        setTipodeBusqueda: function(tdB){
            var $me = this, tdB = tdB || window['tipodeBusqueda'];
            $me.options.tipodeBusqueda = tdB.length ? tdB : typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
        },

        /**
         * Write public methods within the plugin's prototype. They can
         * be called with:
         *
         * @example
         * $('#element').jqueryPlugin('somePublicMethod','Arguments', 'Here', 1001);
         *
         * @param  {[type]} foo [some parameter]
         * @param  {[type]} bar [some other parameter]
         * @return {[type]}
         */
        _buildSQLString: function() {
            // This is a call to a pseudo private method
            //this._pseudoPrivateMethod();
            // This is a call to a real private method. You need to use 'call' or 'apply'
            //privateMethod.call(this);
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime = $me.options.instances[$id],
                adbt_ini=$('#'+$minime.ifields.f_fechaIni).val(),
                adbt_fin=$('#'+$minime.ifields.f_fechaFin).val(),
                adbtt_ini=$('#'+$minime.ifields.f_horaIni).val(),
                adbtt_fin=$('#'+$minime.ifields.f_horaFin).val(),
                sqlS='', $txt='';

            $me.setTipodeBusqueda();

            if(!adbt_ini.length && !adbt_fin.length)
                return $minime.sqlString = sqlS;

            adbt_ini = adbt_ini.length ? $me._cambiaFormatoFecha(adbt_ini) : '2000-01-01';
            adbt_fin = adbt_fin.length ? $me._cambiaFormatoFecha(adbt_fin) : '2100-12-31';

            adbtt_ini = adbtt_ini.length ? adbtt_ini + ":00:00" : "00:00:00";
            adbtt_fin = adbtt_fin.length && adbtt_fin < '24' ? adbtt_fin + ":00:00" : "23:59:59";

            $.each($minime.field, function(k,v){
                sqlS += $minime.xtrasqlpre + "(" + v + " >= '"+adbt_ini+" "+adbtt_ini+"' AND " + v + " <='"+adbt_fin+" "+adbtt_fin+"') " + $minime.xtrasqlpost + " OR ";
            });

            sqlS = sqlS.slice(0, -4);

            sqlS = $minime.field.length > 1 ? " ( " + sqlS + " ) " : sqlS;

            $minime.sqlString = sqlS;

            for (var key in $me.options.instances) {
                if ($me.options.instances.hasOwnProperty(key)) {
                    $txt+=$me.options.instances[key].sqlString.length ? $me.options.instances[key].sqlString+" "+$me.options.tipodeBusqueda+" " : "";
                }
            }

            $me.options.sqlString = $txt;

            return sqlS;

        },

        /**
         * Another public method which acts as a getter method. You can call as any usual
         * public method:
         *
         * @example
         * $('#element').jqueryPlugin('someGetterMethod');
         *
         * to get some interesting info from your plugin.
         *
         * @return {[type]} Return something
         */
        getOptions: function() {
            return this.options;
        },

        getSQLString: function() {
            var $me = this,
            $elem = $me.$el,
            $id = $elem.data('input');
            return $me.options.instances[$id].sqlString;
        },

        getSQLStringAll: function() {
            var $me = this,
                $minime = $me.options.instances,
                $txt = '';

            for (var key in $minime) {
                if ($minime.hasOwnProperty(key)) {
                    $txt+=$minime[key].sqlString.length ? $minime[key].sqlString+" "+$me.options.tipodeBusqueda+" " : "";
                }
            }

            $me.options.sqlString = $txt;

            return $me.options.sqlString;
        },

        cleanAll: function() {
            $('.vx_adcb_limpia').each(function(){this.click();});
        },

        /**
         * You can use the name convention functions started with underscore are
         * private. Really calls to functions starting with underscore are
         * filtered, for example:
         *
         *  @example
         *  $('#element').jqueryPlugin('_pseudoPrivateMethod');  // Will not work
         */
        _cambiaFormatoFecha: function(fecha, formato){
        	if (fecha.length < 10) return '';
        	if (!formato || formato.length==0) var formato='MySQL';
        	var cd='-',
                aFecha=fecha.split(cd),
                sDia=aFecha[0],
                sMes=aFecha[1],
                sAnio=aFecha[2],
                ff='';
        	switch (formato){
            	case 'MySQL':
            		ff=sAnio + '-' + sMes + '-' + sDia;
            		break;
            	case 'JS':
            		ff=sDia + '-' + sMes + '-' + sAnio;
            		break;
            	default:
            		ff=sAnio + '-' + sMes + '-' + sDia;
            		break;
        	}
        	return ff;
        },
    };

    /**
     * This is a real private method. A plugin instance has access to it
     * @return {[type]}
     */
    var privateMethod = function() {
        console.log("privateMethod");
        console.log(this);
    };

    /**
     * This is were we register our plugin withint jQuery plugins.
     * It is a plugin wrapper around the constructor and prevents agains multiple
     * plugin instantiation (soteing a plugin reference within the element's data)
     * and avoid any function starting with an underscore to be called (emulating
     * private functions).
     *
     * @example
     * $('#element').jqueryPlugin({
     *     defaultOption: 'this options overrides a default plugin option',
     *     additionalOption: 'this is a new option'
     * });
     */
    $.fn[pluginName] = function(options) {
        var args = arguments, thisZero = {}, instance = {};

        if (options === undefined || typeof options === 'object') {
            // Creates a new plugin instance, for each selected element, and
            // stores a reference withint the element's data
            return this.reverse().each(function() {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName, new Plugin(this, options));
                }
            });
        } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
            // Call a public pluguin method (not starting with an underscore) for each
            // selected element.
            if (Array.prototype.slice.call(args, 1).length == 0 && $.inArray(options, $.fn[pluginName].getters) != -1) {
                // If the user does not pass any arguments and the method allows to
                // work as a getter then break the chainability so we can return a value
                // instead the element reference.
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoDateCheckBox')[0] !== "undefined" ? $('.vx_autoDateCheckBox')[0] : undefined;
                instance = $.data(thisZero, 'plugin_' + pluginName);
                return instance[options].apply(instance, Array.prototype.slice.call(args, 1));
            } else {
                // Invoke the speficied method on each selected element
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoDateCheckBox')[0] !== "undefined" ? $('.vx_autoDateCheckBox')[0] : undefined;
                thisZero = $([thisZero]);
                return thisZero.reverse().each(function() {
                    instance = $.data(this, 'plugin_' + pluginName);
                    if (instance instanceof Plugin && typeof instance[options] === 'function') {
                        instance[options].apply(instance, Array.prototype.slice.call(args, 1));
                    }
                });
            }
        }
    };

    /**
     * Names of the pluguin methods that can act as a getter method.
     * @type {Array}
     */
    $.fn[pluginName].getters = ['getOptions','getSQLString','getSQLStringAll'];

    /**
     * Default optionsprimero     :   getFirstDayOfCurrentMonth(d),
            ultimo      :   getLastDayOfCurrentMonth(d),
     */
    var d = new Date();
    $.fn[pluginName].defaults = {
        instances   :   [],
        fns         :   {
            hoy         :   d,
            ayer        :   getLastXDays(d, 1),
            lunes       :   getMondayOfCurrentWeek(d),
            domingo     :   getSundayOfCurrentWeek(d),
            primero     :   getDayOfMonth(d, "primero"),
            ultimo      :   getDayOfMonth(d, "ultimo"),
            ultimos10   :   getLastXDays(d, 10),
            pripasado   :   getDayOfMonth(d, "primero", "pasado"),
            ultpasado   :   getDayOfMonth(d, "ultimo", "pasado"),
        },
        cbs         :   [
            {'nombre':'_cb_today', 'label':'Today', 'fn':'today', 'fi':'hoy', 'ff':'hoy'},
            {'nombre':'_cb_yesterday', 'label':'Yesterday', 'fn':'yesterday', 'fi':'ayer', 'ff':'ayer'},
            {'nombre':'_cb_thisweek', 'label':'This week', 'fn':'thisweek', 'fi':'lunes', 'ff':'domingo'},
            {'nombre':'_cb_last10days', 'label':'Last 10 days', 'fn':'last10days', 'fi':'ultimos10', 'ff':'hoy'},
            {'nombre':'_cb_thismonth', 'label':'This month', 'fn':'thismonth', 'fi':'primero', 'ff':'ultimo'},
            {'nombre':'_cb_lastmonth', 'label':'Last month', 'fn':'lastmonth', 'fi':'pripasado', 'ff':'ultpasado'},
        ],
        icbs        :   [],
        ifields     :   [],
        input       :   'input',
        field       :   'field',
        fields      :   {
            f_fechaIni  :   "_ini",
            f_fechaFin  :   "_fin",
            f_horaIni   :   "_time_ini",
            f_horaFin   :   "_time_fin"
        },
        sqlString   :   '',
        tipodeBusqueda : 'AND',
    };
})(jQuery, window, document);


//nuevar
(function($, window, document, undefined) {

    /**
     * Store the plugin name in a variable. It helps you if later decide to
     * change the plugin's name
     * @type {String}
     */
    var pluginName = 'vx_autoSelectMonto';

    /**
     * The plugin constructor
     * @param {DOM Element} element The DOM element where plugin is applied
     * @param {Object} options Options passed to the constructor
     */
    function Plugin(element, options) {

        // Store a reference to the source element
        this.el = element;

        // Store a jQuery reference  to the source element
        this.$el = $(element);

        // Set the instance options extending the plugin defaults and
        // the options passed by the user
        this.options = $.extend({}, $.fn[pluginName].defaults, options);

        // Initialize the plugin instance
        this.init();
    }

    /**
     * Set up your Plugin prototype with desired methods.
     * It is a good practice to implement 'init' and 'destroy' methods.
     */
    Plugin.prototype = {

        /**
         * Initialize the plugin instance.
         * Set any other attribtes, store any other element reference, register
         * listeners, etc
         *
         * When bind listerners remember to name tag it with your plugin's name.
         * Elements can have more than one listener attached to the same event
         * so you need to tag it to unbind the appropriate listener on destroy:
         *
         * @example
         * this.$someSubElement.on('click.' + pluginName, function() {
         *      // Do something
         * });
         *
         */
        init: function() {
            var $me = this,
            $elem = $me.$el,
            $doWrap = $elem.data('dowrap'),
            $id = $elem.data('input'),
            $field = $elem.data('field'),
            $a={}, $fs_id=$id+'_bt_fs', $minime={};

            $field = $field.split(",");

            $me.options.tipodeBusqueda = typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
            $me.options.instances[$id] = {};
            $minime = $me.options.instances[$id];
            $minime.input = $id;
            $minime.field = $field;
            $minime.xtrasqlpre = $elem.data('xtrasqlpre') === undefined ? "" : $elem.data('xtrasqlpre');
            $minime.xtrasqlpost = $elem.data('xtrasqlpost') === undefined ? "" : $elem.data('xtrasqlpost');
            $minime.sqlString = "";

            $minime.ifields = {

                f_comparador : $id + "_comp_sel",
                f_monto : $id + "_monto"
            };



            if($doWrap == 'Si')
            {
                var $div = $('<div />',{
                    'class':"dved",
                    'style':"display: inline; float: left;"
                }),
                $fs = $('<fieldset />',{
                    'name':$fs_id,
                    'class':"busqueda_access ba_quantity",
                    'id':$fs_id
                }),
                $le = $('<legend />').text($elem.data('title')),
                $table = $('<table />',{
                    'style':"width: 100%",
                }), $place;
                $tmpHtml = '';

				$tmpHtml += '<select class="selectopts vx_autoSelectMontoSelectize" name="'+$minime.ifields.f_comparador+'" id="'+$minime.ifields.f_comparador+'" style="width:120px;">';
				$tmpHtml += '<option value="eq">equal</option>';
				$tmpHtml += '<option value="ne">not equal</option>';
				$tmpHtml += '<option value="lt">less</option>';
				$tmpHtml += '<option value="le">less or equal</option>';
				$tmpHtml += '<option value="gt">greater</option>';
				$tmpHtml += '<option value="ge">grtr or equal</option>';
				$tmpHtml += '</select>';
				$tmpHtml += '&nbsp;<input name="'+$minime.ifields.f_monto+'" id="'+$minime.ifields.f_monto+'" type="text" autocomplete="off" size="10" data-campo="'+$field+'" class="auto ignore-val" data-autonumeric="{mNum:10,mDec:2,aSep:\',\'}"/>';
				$tmpHtml += '</td>';

                //$tmpHtml += '<td><input name="quantity" id="quantity" type="text" autocomplete="off" size="10" data-campo="quantity" class="auto ignore-val" data-autonumeric="{mNum:10,mDec:2,aSep:\',\'}"/></td>';


                $place = $($elem.siblings('div')[0]);

                $table.append($tmpHtml);


                $fs.append($le);
                $fs.append($table);
                $fs.append($elem);
                $div.append($fs);

                $place.after($div);

                setTimeout(function(){
                    init_autoNumeric($id+'_bt_fs');
                    //init_datepicker($id+'_bt_fs');
                    $('.vx_autoSelectMontoSelectize').filter('select:not(.notSelectize, [class^=ui-], [multiple])').selectize();
                    $.each($minime.ifields, function(k,v){
                        $('#'+v).on('change', function(){
                            $me._buildSQLString();
                        });
                    })
                }, 100);
            }

            $a = $('<a />', {
                href:'javascript:void(0);',
                'class':'vx_adcb_limpia',
            }).append($('<img />', {
                src:'../img/16-refresh.png',
                title:'Limpiar'
            })).on('click', function(){
                var $tmp = $('#'+$fs_id).find('input');//$elem.parent().find('input');
                $tmp.filter("[type=text]").val('');
                $tmp.filter("[type=radio]").prop('checked', false);
                $me._buildSQLString();
            });

            $elem.after($a);

            $minime.icbs = [];
            $($me.options.cbs).reverse().each(function(k,v){
                var icbsid = $id + this.nombre, tmpel = {}, tmplbl = {};
                $minime.icbs[icbsid] = {
                    fn : this.fn
                    ,fi : this.fi
                    ,ff : this.ff
                };
                /*tmpel = $('<input />', {
                     id:    icbsid
                    ,name:  $id + "_vx_autoSelectMonto"
                    ,value: 'ON'
                    ,type:  'radio'
                    ,checked:false
                    ,'class':"vx_adcb_class"
                }).on('change', function(){
                    $('#'+$minime.ifields.f_fechaIni).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].fi]);
                    $('#'+$minime.ifields.f_fechaFin).datepicker('setDate', $me.options.fns[$minime.icbs[icbsid].ff]);
                    $me._buildSQLString();
                });*/

                //tmplbl = $('<label />', { 'for': icbsid, 'class':"vx_adcb_class" }).html(this.label + '&nbsp;&nbsp;');

                $elem.after(tmplbl).after(tmpel);
                if(k<4&&((k+1)%3==0))
                    $elem.after("<br/>");
            });
        },

        /**
         * The 'destroy' method is were you free the resources used by your plugin:
         * references, unregister listeners, etc.
         *
         * Remember to unbind for your event:
         *
         * @example
         * this.$someSubElement.off('.' + pluginName);
         *
         * Above example will remove any listener from your plugin for on the given
         * element.
         */
        destroy: function() {

            // Remove any attached data from your plugin
            this.$el.removeData();
        },

        setTipodeBusqueda: function(tdB){
            var $me = this, tdB = tdB || window['tipodeBusqueda'];
            $me.options.tipodeBusqueda = tdB.length ? tdB : typeof window['tipodeBusqueda'] === "string" ? window['tipodeBusqueda'] : 'AND';
        },

        /**
         * Write public methods within the plugin's prototype. They can
         * be called with:
         *
         * @example
         * $('#element').jqueryPlugin('somePublicMethod','Arguments', 'Here', 1001);
         *
         * @param  {[type]} foo [some parameter]
         * @param  {[type]} bar [some other parameter]
         * @return {[type]}
         */
        _buildSQLString: function() {
            // This is a call to a pseudo private method
            //this._pseudoPrivateMethod();
            // This is a call to a real private method. You need to use 'call' or 'apply'
            //privateMethod.call(this);
            var $me = this,
                $elem = $me.$el,
                $id = $elem.data('input'),
                $minime = $me.options.instances[$id],

                asm_monto=$('#'+$minime.ifields.f_monto).val(),
                asm_comp=$('#'+$minime.ifields.f_comparador + " option:selected").val(),

                sqlS='', $txt='';

            $me.setTipodeBusqueda();

            if(!asm_monto.length)
                return $minime.sqlString = sqlS;

            asm_monto = asm_monto.length ? vx_utils.parseFloat(asm_monto) : '';

            //a partir de aqui puedes trabajar con tranquilidad.

            $.each($minime.field, function(k,v){
                sqlS += $minime.xtrasqlpre + "(" + v + " " + obtenComparador(asm_comp) + "'"+asm_monto+"') " + $minime.xtrasqlpost + " OR ";
            });

            sqlS = sqlS.slice(0, -4);

            sqlS = $minime.field.length > 1 ? " ( " + sqlS + " ) " : sqlS;

            $minime.sqlString = sqlS;

            for (var key in $me.options.instances) {
                if ($me.options.instances.hasOwnProperty(key)) {
                    $txt+=$me.options.instances[key].sqlString.length ? $me.options.instances[key].sqlString+" "+$me.options.tipodeBusqueda+" " : "";
                }
            }

            $me.options.sqlString = $txt;

            return sqlS;

        },

        /**
         * Another public method which acts as a getter method. You can call as any usual
         * public method:
         *
         * @example
         * $('#element').jqueryPlugin('someGetterMethod');
         *
         * to get some interesting info from your plugin.
         *
         * @return {[type]} Return something
         */
        getOptions: function() {
            return this.options;
        },

        getSQLString: function() {
            var $me = this,
            $elem = $me.$el,
            $id = $elem.data('input');
            return $me.options.instances[$id].sqlString;
        },

        getSQLStringAll: function() {
            var $me = this,
                $minime = $me.options.instances,
                $txt = '';

            for (var key in $minime) {
                if ($minime.hasOwnProperty(key)) {
                    $txt+=$minime[key].sqlString.length ? $minime[key].sqlString+" "+$me.options.tipodeBusqueda+" " : "";
                }
            }

            $me.options.sqlString = $txt;

            return $me.options.sqlString;
        },

        cleanAll: function() {
            $('.vx_adcb_limpia').each(function(){this.click();});
        },

        /**
         * You can use the name convention functions started with underscore are
         * private. Really calls to functions starting with underscore are
         * filtered, for example:
         *
         *  @example
         *  $('#element').jqueryPlugin('_pseudoPrivateMethod');  // Will not work
         */
        _cambiaFormatoFecha: function(fecha, formato){
        	if (fecha.length < 10) return '';
        	if (!formato || formato.length==0) var formato='MySQL';
        	var cd='-',
                aFecha=fecha.split(cd),
                sDia=aFecha[0],
                sMes=aFecha[1],
                sAnio=aFecha[2],
                ff='';
        	switch (formato){
            	case 'MySQL':
            		ff=sAnio + '-' + sMes + '-' + sDia;
            		break;
            	case 'JS':
            		ff=sDia + '-' + sMes + '-' + sAnio;
            		break;
            	default:
            		ff=sAnio + '-' + sMes + '-' + sDia;
            		break;
        	}
        	return ff;
        },
    };

    /**
     * This is a real private method. A plugin instance has access to it
     * @return {[type]}
     */
    var privateMethod = function() {
        console.log("privateMethod");
        console.log(this);
    };

    /**
     * This is were we register our plugin withint jQuery plugins.
     * It is a plugin wrapper around the constructor and prevents agains multiple
     * plugin instantiation (soteing a plugin reference within the element's data)
     * and avoid any function starting with an underscore to be called (emulating
     * private functions).
     *
     * @example
     * $('#element').jqueryPlugin({
     *     defaultOption: 'this options overrides a default plugin option',
     *     additionalOption: 'this is a new option'
     * });
     */
    $.fn[pluginName] = function(options) {
        var args = arguments, thisZero = {}, instance = {};

        if (options === undefined || typeof options === 'object') {
            // Creates a new plugin instance, for each selected element, and
            // stores a reference withint the element's data
            return this.reverse().each(function() {
                if (!$.data(this, 'plugin_' + pluginName)) {
                    $.data(this, 'plugin_' + pluginName, new Plugin(this, options));
                }
            });
        } else if (typeof options === 'string' && options[0] !== '_' && options !== 'init') {
            // Call a public pluguin method (not starting with an underscore) for each
            // selected element.
            if (Array.prototype.slice.call(args, 1).length == 0 && $.inArray(options, $.fn[pluginName].getters) != -1) {
                // If the user does not pass any arguments and the method allows to
                // work as a getter then break the chainability so we can return a value
                // instead the element reference.
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoSelectMonto')[0] !== "undefined" ? $('.vx_autoSelectMonto')[0] : undefined;
                instance = $.data(thisZero, 'plugin_' + pluginName);
                return instance[options].apply(instance, Array.prototype.slice.call(args, 1));
            } else {
                // Invoke the speficied method on each selected element
                thisZero = typeof this[0] !== "undefined" ? this[0] : typeof $('.vx_autoSelectMonto')[0] !== "undefined" ? $('.vx_autoSelectMonto')[0] : undefined;
                thisZero = $([thisZero]);
                return thisZero.reverse().each(function() {
                    instance = $.data(this, 'plugin_' + pluginName);
                    if (instance instanceof Plugin && typeof instance[options] === 'function') {
                        instance[options].apply(instance, Array.prototype.slice.call(args, 1));
                    }
                });
            }
        }
    };

    /**
     * Names of the pluguin methods that can act as a getter method.
     * @type {Array}
     */
    $.fn[pluginName].getters = ['getOptions','getSQLString','getSQLStringAll'];

    /**
     * Default optionsprimero     :   getFirstDayOfCurrentMonth(d),
            ultimo      :   getLastDayOfCurrentMonth(d),
     */
    var d = new Date();
    $.fn[pluginName].defaults = {
        instances   :   [],
        fns         :   {
            hoy         :   d,
            ayer        :   getLastXDays(d, 1),
            lunes       :   getMondayOfCurrentWeek(d),
            domingo     :   getSundayOfCurrentWeek(d),
            primero     :   getDayOfMonth(d, "primero"),
            ultimo      :   getDayOfMonth(d, "ultimo"),
            ultimos10   :   getLastXDays(d, 10),
            pripasado   :   getDayOfMonth(d, "primero", "pasado"),
            ultpasado   :   getDayOfMonth(d, "ultimo", "pasado"),
        },
        cbs         :   [
            {'nombre':'_cb_today', 'label':'Today', 'fn':'today', 'fi':'hoy', 'ff':'hoy'},
            {'nombre':'_cb_yesterday', 'label':'Yesterday', 'fn':'yesterday', 'fi':'ayer', 'ff':'ayer'},
            {'nombre':'_cb_thisweek', 'label':'This week', 'fn':'thisweek', 'fi':'lunes', 'ff':'domingo'},
            {'nombre':'_cb_last10days', 'label':'Last 10 days', 'fn':'last10days', 'fi':'ultimos10', 'ff':'hoy'},
            {'nombre':'_cb_thismonth', 'label':'This month', 'fn':'thismonth', 'fi':'primero', 'ff':'ultimo'},
            {'nombre':'_cb_lastmonth', 'label':'Last month', 'fn':'lastmonth', 'fi':'pripasado', 'ff':'ultpasado'},
        ],
        icbs        :   [],
        ifields     :   [],
        input       :   'input',
        field       :   'field',
        fields      :   {
            f_comparador : "_comp_sel",
            f_monto : "_monto"
        },
        sqlString   :   '',
        tipodeBusqueda : 'AND',
    };
})(jQuery, window, document);

function rgb2hex(rgb)
{
    if(rgb.search("rgb") == -1)
        return rgb;
    else
    {
        rgb = rgb.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+))?\)$/);
        function hex(x)
        {
           return ("0" + parseInt(x).toString(16)).slice(-2);
        }
        return "#" + hex(rgb[1]) + hex(rgb[2]) + hex(rgb[3]);
    }
}